<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReelsTable extends Migration {

	public function up()
	{
		Schema::create('reels', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('avatar_id')->unsigned();
			$table->integer('theme_id')->unsigned();
			$table->string('name', 80)->nullable();
			$table->string('last_name', 80)->nullable();
			$table->string('vocation')->nullable();
			$table->string('current_city')->nullable();
			$table->string('picture')->nullable();
			$table->string('thumbnail')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reels');
	}
}