<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reels', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reels', function(Blueprint $table) {
			$table->foreign('avatar_id')->references('id')->on('avatars')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reels', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('colums', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('colums', function(Blueprint $table) {
			$table->foreign('column_type_id')->references('id')->on('column_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('column_section', function(Blueprint $table) {
			$table->foreign('column_id')->references('id')->on('colums')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('column_section', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->foreign('reel_id')->references('id')->on('reels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->foreign('object_type_id')->references('id')->on('object_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('lists', function(Blueprint $table) {
			$table->foreign('depends_on')->references('id')->on('lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('column_list', function(Blueprint $table) {
			$table->foreign('column_id')->references('id')->on('colums')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('column_list', function(Blueprint $table) {
			$table->foreign('list_id')->references('id')->on('lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('list_object', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('object')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('list_object', function(Blueprint $table) {
			$table->foreign('list')->references('id')->on('lists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('column_reel', function(Blueprint $table) {
			$table->foreign('column_id')->references('id')->on('colums')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('column_reel', function(Blueprint $table) {
			$table->foreign('reel_id')->references('id')->on('reels')
						->onDelete('no action')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('reels', function(Blueprint $table) {
			$table->dropForeign('reels_user_id_foreign');
		});
		Schema::table('reels', function(Blueprint $table) {
			$table->dropForeign('reels_avatar_id_foreign');
		});
		Schema::table('reels', function(Blueprint $table) {
			$table->dropForeign('reels_theme_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_theme_id_foreign');
		});
		Schema::table('colums', function(Blueprint $table) {
			$table->dropForeign('colums_theme_id_foreign');
		});
		Schema::table('colums', function(Blueprint $table) {
			$table->dropForeign('colums_column_type_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('column_section', function(Blueprint $table) {
			$table->dropForeign('column_section_column_id_foreign');
		});
		Schema::table('column_section', function(Blueprint $table) {
			$table->dropForeign('column_section_section_id_foreign');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->dropForeign('object_reel_id_foreign');
		});
		Schema::table('object', function(Blueprint $table) {
			$table->dropForeign('object_object_type_id_foreign');
		});
		Schema::table('lists', function(Blueprint $table) {
			$table->dropForeign('lists_depends_on_foreign');
		});
		Schema::table('column_list', function(Blueprint $table) {
			$table->dropForeign('column_list_column_id_foreign');
		});
		Schema::table('column_list', function(Blueprint $table) {
			$table->dropForeign('column_list_list_id_foreign');
		});
		Schema::table('list_object', function(Blueprint $table) {
			$table->dropForeign('list_object_object_id_foreign');
		});
		Schema::table('list_object', function(Blueprint $table) {
			$table->dropForeign('list_object_list_foreign');
		});
		Schema::table('column_reel', function(Blueprint $table) {
			$table->dropForeign('column_reel_column_id_foreign');
		});
		Schema::table('column_reel', function(Blueprint $table) {
			$table->dropForeign('column_reel_reel_id_foreign');
		});
	}
}