<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDetailsTable extends Migration {

	public function up()
	{
		Schema::create('user_details', function(Blueprint $table) {
			$table->increments('id');
			$table->string('raison_sociale')->nullable();
			$table->string('address')->nullable();
			$table->string('nationality');
			$table->date('date_of_birth')->nullable();
			$table->string('groupe_sanguin')->nullable();
			$table->string('type_identification', 30)->nullable();
			$table->string('numero_identification', 30)->nullable();
			$table->string('numero_carte_etudiant', 20)->nullable();
			$table->string('ninea')->nullable();
			$table->string('numero_permis_conduirre')->nullable();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_details');
	}
}