<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('email')->unique();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('password');
			$table->string('photo')->nullable();
			$table->integer('type_profil_id')->unsigned()->index();
			$table->tinyInteger('is_simple_user')->default('1');
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}