<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLinkedAccountsTable extends Migration {

	public function up()
	{
		Schema::create('linked_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('login');
			$table->string('last_token');
			$table->string('expired_date')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('systeme_id')->unsigned()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('linked_accounts');
	}
}