<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSystemesTable extends Migration {

	public function up()
	{
		Schema::create('systemes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('libelle');
			$table->string('logo')->nullable();
			$table->string('base_url')->nullable();
			$table->string('auth_url')->nullable();
			$table->string('register_url')->nullable();
			$table->string('username');
			$table->string('password');
			$table->string('access_token');
			$table->tinyInteger('status')->default('1');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('systemes');
	}
}