<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('type_profil_id')->references('id')->on('type_profils')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->foreign('secteur_id')->references('id')->on('secteurs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('type_profil_procedures', function(Blueprint $table) {
			$table->foreign('type_profil_id')->references('id')->on('type_profils')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('type_profil_procedures', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('procedures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('linked_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('linked_accounts', function(Blueprint $table) {
			$table->foreign('systeme_id')->references('id')->on('systemes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('procedure_id')->references('id')->on('procedures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_type_profil_id_foreign');
		});
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('procedures', function(Blueprint $table) {
			$table->dropForeign('procedures_secteur_id_foreign');
		});
		Schema::table('type_profil_procedures', function(Blueprint $table) {
			$table->dropForeign('type_profil_procedures_type_profil_id_foreign');
		});
		Schema::table('type_profil_procedures', function(Blueprint $table) {
			$table->dropForeign('type_profil_procedures_procedure_id_foreign');
		});
		Schema::table('linked_accounts', function(Blueprint $table) {
			$table->dropForeign('linked_accounts_user_id_foreign');
		});
		Schema::table('linked_accounts', function(Blueprint $table) {
			$table->dropForeign('linked_accounts_systeme_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_user_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_procedure_id_foreign');
		});
	}
}