<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;
    protected $fillable = array('first_name', 'family_name', 'country_id', 'city_id', 'street', 'floor_number', 'phone', 'note', 'user_id', 'discount_coupon');

    public function getCountry()
    {
        return $this->belongsTo('Countries', 'country_id');
    }

    public function getCity()
    {
        return $this->belongsTo('Cities', 'city_id');
    }

    public function getCard()
    {
        return $this->belongsTo('Credit', 'cart_id');
    }

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

}