<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('first_name', 255);
			$table->string('family_name', 255);
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->string('street', 255);
			$table->string('floor_number', 255)->nullable();
			$table->string('phone', 255);
			$table->string('note', 255);
			$table->integer('user_id')->unsigned();
			$table->string('discount_coupon', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}