<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model 
{

    protected $table = 'branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function branchTranslations()
    {
        return $this->hasMany('BranchTranslation');
    }

    public function workTimes()
    {
        return $this->hasMany('WorkTime');
    }

    public function phones()
    {
        return $this->hasMany('Phone');
    }

    public function emails()
    {
        return $this->hasMany('Email');
    }

}