<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model 
{

    protected $table = 'partners';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function partnerTranslations()
    {
        return $this->hasMany('PartnerTranslation');
    }

    public function images()
    {
        return $this->morphMany('Image');
    }

}