<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 20);
			$table->string('last_name', 20);
			$table->enum('user_type', array(''));
			$table->string('email', 20);
			$table->string('phone', 20);
			$table->string('password', 50);
			$table->boolean('is_ban')->default(1);
			$table->text('ban_reason');
			$table->boolean('is_active')->default(1);
			$table->enum('gender', array(''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}