<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactUsRepliesTable extends Migration {

	public function up()
	{
		Schema::create('contactUs_replies', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contact_us_id')->unsigned();
			$table->enum('sender', array(''));
			$table->longText('content');
			$table->datetime('read_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contactUs_replies');
	}
}