<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkTimesTable extends Migration {

	public function up()
	{
		Schema::create('work_times', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('branch_id')->unsigned()->nullable();
			$table->integer('dayOfWeek_id')->unsigned()->nullable();
			$table->time('start_time');
			$table->time('end_time');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('work_times');
	}
}