<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('role_translations', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_translations', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_translations', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('news_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('new_translations', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('partner_translations', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('previousWork_translations', function(Blueprint $table) {
			$table->foreign('previousWork_id')->references('id')->on('previousWork')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('informationCenter_translations', function(Blueprint $table) {
			$table->foreign('informationCenter_id')->references('id')->on('information_center')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('informationCenter_id')->references('id')->on('information_center')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('testimonial_translations', function(Blueprint $table) {
			$table->foreign('testimonial_id')->references('id')->on('testimonials')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_translations', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('daysOfWeek_translations', function(Blueprint $table) {
			$table->foreign('dayOfWeek_id')->references('id')->on('daysOfWeek')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('work_times', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('work_times', function(Blueprint $table) {
			$table->foreign('dayOfWeek_id')->references('id')->on('daysOfWeek')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contactUs_replies', function(Blueprint $table) {
			$table->foreign('contact_us_id')->references('id')->on('contact_us')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('about_translations', function(Blueprint $table) {
			$table->foreign('about_id')->references('id')->on('about')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('slider_translations', function(Blueprint $table) {
			$table->foreign('slider_id')->references('id')->on('sliders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('newsCategory_translations', function(Blueprint $table) {
			$table->foreign('newCategory_id')->references('id')->on('news_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('phones', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('emails', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('directors', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('director_translations', function(Blueprint $table) {
			$table->foreign('dirctor_id')->references('id')->on('directors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('job_title_translations', function(Blueprint $table) {
			$table->foreign('job_title_id')->references('id')->on('job_titles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('speeches', function(Blueprint $table) {
			$table->foreign('director_id')->references('id')->on('directors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('SpeechTranslation', function(Blueprint $table) {
			$table->foreign('speechId')->references('id')->on('speeches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('role_translations', function(Blueprint $table) {
			$table->dropForeign('role_translations_role_id_foreign');
		});
		Schema::table('permission_translations', function(Blueprint $table) {
			$table->dropForeign('permission_translations_permission_id_foreign');
		});
		Schema::table('service_translations', function(Blueprint $table) {
			$table->dropForeign('service_translations_service_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_category_id_foreign');
		});
		Schema::table('new_translations', function(Blueprint $table) {
			$table->dropForeign('new_translations_news_id_foreign');
		});
		Schema::table('partner_translations', function(Blueprint $table) {
			$table->dropForeign('partner_translations_partner_id_foreign');
		});
		Schema::table('previousWork_translations', function(Blueprint $table) {
			$table->dropForeign('previousWork_translations_previousWork_id_foreign');
		});
		Schema::table('informationCenter_translations', function(Blueprint $table) {
			$table->dropForeign('informationCenter_translations_informationCenter_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_informationCenter_id_foreign');
		});
		Schema::table('testimonial_translations', function(Blueprint $table) {
			$table->dropForeign('testimonial_translations_testimonial_id_foreign');
		});
		Schema::table('country_translations', function(Blueprint $table) {
			$table->dropForeign('country_translations_country_id_foreign');
		});
		Schema::table('branch_translations', function(Blueprint $table) {
			$table->dropForeign('branch_translations_branch_id_foreign');
		});
		Schema::table('daysOfWeek_translations', function(Blueprint $table) {
			$table->dropForeign('daysOfWeek_translations_dayOfWeek_id_foreign');
		});
		Schema::table('work_times', function(Blueprint $table) {
			$table->dropForeign('work_times_branch_id_foreign');
		});
		Schema::table('work_times', function(Blueprint $table) {
			$table->dropForeign('work_times_dayOfWeek_id_foreign');
		});
		Schema::table('contactUs_replies', function(Blueprint $table) {
			$table->dropForeign('contactUs_replies_contact_us_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('about_translations', function(Blueprint $table) {
			$table->dropForeign('about_translations_about_id_foreign');
		});
		Schema::table('slider_translations', function(Blueprint $table) {
			$table->dropForeign('slider_translations_slider_id_foreign');
		});
		Schema::table('newsCategory_translations', function(Blueprint $table) {
			$table->dropForeign('newsCategory_translations_newCategory_id_foreign');
		});
		Schema::table('phones', function(Blueprint $table) {
			$table->dropForeign('phones_branch_id_foreign');
		});
		Schema::table('emails', function(Blueprint $table) {
			$table->dropForeign('emails_branch_id_foreign');
		});
		Schema::table('directors', function(Blueprint $table) {
			$table->dropForeign('directors_job_title_id_foreign');
		});
		Schema::table('director_translations', function(Blueprint $table) {
			$table->dropForeign('director_translations_dirctor_id_foreign');
		});
		Schema::table('job_title_translations', function(Blueprint $table) {
			$table->dropForeign('job_title_translations_job_title_id_foreign');
		});
		Schema::table('speeches', function(Blueprint $table) {
			$table->dropForeign('speeches_director_id_foreign');
		});
		Schema::table('SpeechTranslation', function(Blueprint $table) {
			$table->dropForeign('SpeechTranslation_speechId_foreign');
		});
	}
}