<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssignTo extends Model 
{

    protected $table = 'assign_to';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'assign_id');

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function assign()
    {
        return $this->belongsTo('User', 'assign_id');
    }

}