<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'project';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'start_at', 'end_at', 'description', 'total_days', 'status', 'progress', 'time_rate', 'created_by', 'total', 'remain');

    public function tasks()
    {
        return $this->hasMany('Task', 'project_id');
    }

    public function comments()
    {
        return $this->hasMany('ProjectComment', 'project_id');
    }

    public function users()
    {
        return $this->belongsToMany('User', 'project_user', 'project_id', 'user_id');
    }

    public function created_by()
    {
        return $this->belongsTo('User', 'created_by');
    }

    public function payments()
    {
        return $this->hasMany('ProjectPayment', 'project_id');
    }

}