<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProjectComment extends Model 
{

    protected $table = 'project_comment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'massage', 'created_by');

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'created_by');
    }

}