<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'task';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'created_by', 'title', 'details', 'status', 'due_date', 'total_time');

    public function comments()
    {
        return $this->hasMany('TaskComment', 'task_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'created_by');
    }

    public function assigns()
    {
        return $this->hasMany('AssignTo', 'task_id');
    }

}