<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaskComment extends Model 
{

    protected $table = 'task_comment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('task_id', 'message', 'created_by');

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'created_by');
    }

}