<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('lession_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('lesson_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_follows', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_follows', function(Blueprint $table) {
			$table->foreign('followed_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('socials', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->dropForeign('words_category_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_category_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_lession_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_word_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_word_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_user_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_lesson_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_answer_id_foreign');
		});
		Schema::table('users_follows', function(Blueprint $table) {
			$table->dropForeign('users_follows_follower_id_foreign');
		});
		Schema::table('users_follows', function(Blueprint $table) {
			$table->dropForeign('users_follows_followed_id_foreign');
		});
		Schema::table('socials', function(Blueprint $table) {
			$table->dropForeign('socials_user_id_foreign');
		});
	}
}