<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lineitems', function(Blueprint $table) {
			$table->foreign('order_id')->references('order_id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lineitems', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('siblists', function(Blueprint $table) {
			$table->foreign('folder_id')->references('id')->on('folders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_siblist', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_siblist', function(Blueprint $table) {
			$table->foreign('siblist_id')->references('id')->on('siblists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_segment', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_segment', function(Blueprint $table) {
			$table->foreign('segment_id')->references('id')->on('segments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('criteria', function(Blueprint $table) {
			$table->foreign('segmen_id')->references('id')->on('segments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('lineitems', function(Blueprint $table) {
			$table->dropForeign('lineitems_order_id_foreign');
		});
		Schema::table('lineitems', function(Blueprint $table) {
			$table->dropForeign('lineitems_product_id_foreign');
		});
		Schema::table('siblists', function(Blueprint $table) {
			$table->dropForeign('siblists_folder_id_foreign');
		});
		Schema::table('contact_siblist', function(Blueprint $table) {
			$table->dropForeign('contact_siblist_contact_id_foreign');
		});
		Schema::table('contact_siblist', function(Blueprint $table) {
			$table->dropForeign('contact_siblist_siblist_id_foreign');
		});
		Schema::table('contact_segment', function(Blueprint $table) {
			$table->dropForeign('contact_segment_contact_id_foreign');
		});
		Schema::table('contact_segment', function(Blueprint $table) {
			$table->dropForeign('contact_segment_segment_id_foreign');
		});
		Schema::table('criteria', function(Blueprint $table) {
			$table->dropForeign('criteria_segmen_id_foreign');
		});
	}
}