<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Segment extends Eloquent {

	protected $table = 'segments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contacts()
	{
		return $this->belongsToMany('ContactSegment');
	}

	public function criterion()
	{
		return $this->hasOne('Criterion');
	}

}