<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpleoTable extends Migration {

	public function up()
	{
		Schema::create('empleo', function(Blueprint $table) {
			$table->increments('id');
			$table->string('cargo', 100)->nullable();
			$table->string('empleador', 100)->nullable();
			$table->string('trabaja_desde', 10)->nullable();
			$table->decimal('salario_mensual', 8,2)->default('0');
			$table->decimal('bonos_aguinaldos', 8,2)->nullable()->default('0');
			$table->char('moneda_salario_aguinaldo', 5);
			$table->string('cargo_conyuge', 100)->nullable();
			$table->string('empleador_conyuge', 100)->nullable();
			$table->decimal('salario_mensual_conyuge', 8,2)->nullable()->default('0');
			$table->decimal('bonos_aguinaldos_conyuge', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('empleo');
	}
}