<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookmakerReviewsTable extends Migration {

	public function up()
	{
		Schema::create('bookmaker_reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->integer('bookmaker_id')->unsigned()->nullable()->index();
			$table->text('review')->nullable();
			$table->float('total_rating')->nullable();
			$table->float('storage')->nullable();
			$table->float('line_prematch')->nullable();
			$table->float('line_life')->nullable();
			$table->float('coefficients')->nullable();
			$table->float('convenience')->nullable();
			$table->float('support')->nullable();
			$table->float('bonuses')->nullable();
			$table->float('manufacturability')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bookmaker_reviews');
	}
}