<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->text('comment')->nullable();
			$table->integer('parent_id')->nullable();
			$table->integer('likes')->nullable();
			$table->integer('dislikes')->nullable();
			$table->string('object_type')->index();
			$table->bigInteger('object_id')->index();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}