<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchCardsTable extends Migration {

	public function up()
	{
		Schema::create('match_cards', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('match_id')->primary()->unsigned()->index();
			$table->integer('player_id')->primary()->unsigned()->index();
			$table->integer('time')->unsigned();
			$table->integer('overtime')->nullable();
			$table->enum('type', array('yc', '2yc', 'rc'));
		});
	}

	public function down()
	{
		Schema::drop('match_cards');
	}
}