<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerStatisticsTable extends Migration {

	public function up()
	{
		Schema::create('player_statistics', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('player_id')->unsigned()->index();
			$table->integer('goals')->nullable();
			$table->integer('passes')->nullable();
			$table->integer('titles')->nullable();
			$table->integer('awards')->nullable();
			$table->integer('goal_ratio')->nullable();
			$table->integer('penalty')->nullable();
			$table->string('yc')->nullable();
			$table->integer('rc')->nullable();
			$table->string('games')->nullable();
			$table->integer('wins')->nullable();
			$table->integer('draws')->nullable();
			$table->integer('loses')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('player_statistics');
	}
}