<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRefereesTable extends Migration {

	public function up()
	{
		Schema::create('referees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('slug')->unique()->nullable();
			$table->string('img')->nullable();
			$table->integer('city_id')->primary()->unsigned();
			$table->date('birthday')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('referees');
	}
}