<?php

class Tournament extends Eloquent {

	protected $table = 'tournaments';
	public $timestamps = false;
	protected $fillable = array('name', 'slug', 'year_foundation', 'country_id', 'popular');

	public function tournamentSeasons()
	{
		return $this->hasMany('TournamentSeason');
	}

	public function stadiums()
	{
		return $this->belongsToMany('Stadium');
	}

	public function galleries()
	{
		return $this->morphMany('Gallery', 'entity');
	}

}