<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = false;
    protected $fillable = array('name', 'country_id');

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function referees()
    {
        return $this->hasMany('Referee');
    }

    public function stadiums()
    {
        return $this->hasMany('Stadium');
    }

    public function teams()
    {
        return $this->hasMany('Team');
    }

}