<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonTable extends Migration {

	public function up()
	{
		Schema::create('lesson', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('course_id');
			$table->string('name');
			$table->integer('public');
			$table->timestamps();
			$table->string('alias');
			$table->string('sorting_order');
			$table->datetime('starting_date');
			$table->text('short_desc');
			$table->integer('count_hours');
			$table->string('title');
			$table->text('meta_description');
			$table->text('meta_keywords');
		});
	}

	public function down()
	{
		Schema::drop('lesson');
	}
}