<?php

namespace App\User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->hasOne('Role');
	}

	public function account()
	{
		return $this->hasOne('Account');
	}

	public function feedactivities()
	{
		return $this->hasMany('Feedsactivity');
	}

}