<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessesTable extends Migration {

	public function up()
	{
		Schema::create('businesses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->integer('package_id')->unsigned()->index()->default('0');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('address', 255);
			$table->string('address_1', 255)->nullable();
			$table->string('city', 255);
			$table->string('state', 255);
			$table->string('country', 255);
			$table->string('phone', 255);
			$table->string('phone_1', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->string('token', 255);
			$table->boolean('is_deleted')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('businesses');
	}
}