<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRouteDetailsTable extends Migration {

	public function up()
	{
		Schema::create('route_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('menu_id')->unsigned()->index();
			$table->string('name', 255);
			$table->string('route', 255);
			$table->boolean('is_deleted')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('route_details');
	}
}