<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned()->default('0');
			$table->integer('role_id')->unsigned()->default('0');
			$table->string('name', 255);
			$table->tinyInteger('type');
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('phone', 255);
			$table->string('phone_1', 255)->nullable();
			$table->string('remember_token', 255)->nullable();
			$table->string('position', 255);
			$table->string('address', 255);
			$table->string('address_1', 255)->nullable();
			$table->string('image', 255)->nullable();
			$table->boolean('is_deleted')->nullable()->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}