<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDreamsTable extends Migration {

	public function up()
	{
		Schema::create('dreams', function(Blueprint $table) {
			$table->increments('id');
			$table->json('title');
			$table->json('description');
			$table->enum('status', array('pending', 'processing', 'finished'));
			$table->string('user_name');
			$table->string('interpreter_name');
			$table->integer('plan_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->string('voice_record');
			$table->enum('marital_status', array('single', 'married'));
			$table->integer('age');
			$table->enum('gender', array('male', 'female'));
			$table->tinyInteger('employed');
			$table->tinyInteger('have_childrens');
			$table->string('dream_time');
			$table->tinyInteger('mental_illness');
			$table->tinyInteger('guidance_prayer');
			$table->tinyInteger('notification');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('dreams');
	}
}