<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'dream_id', 'plan_price');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function dream()
	{
		return $this->belongsTo('App\Models\Dream');
	}

}