<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->string('customer_name');
			$table->string('customer_email');
			$table->string('customer_password');
			$table->string('customer_phone');
			$table->string('customer_favorites')->nullable();
			$table->bigInteger('customer_address_default')->unsigned()->nullable();
			$table->bigInteger('customer_saved_cards')->unsigned();
			$table->timestamps();
			$table->bigInteger('active_order')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}