<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DispensersTable extends Model 
{

    protected $table = 'dispenser_table';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function worker()
    {
        return $this->belongsTo('WorkerInformationTable');
    }

    public function supervisor()
    {
        return $this->belongsTo('SuperVisorInformationTable');
    }

}