<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SuperVisorInformationTable extends Model 
{

    protected $table = 'supervisor_infornation_table';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function worker()
    {
        return $this->hasMany('WorkerInformationTable');
    }

    public function dispenser()
    {
        return $this->hasMany('DispensersTable');
    }

    public function absence()
    {
        return $this->hasMany('AbsecneTable');
    }

}