<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkerInformationTable extends Model 
{

    protected $table = 'worker_information_table';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function taskAndAlert()
    {
        return $this->hasMany('TaskAndAlert');
    }

    public function absence()
    {
        return $this->hasMany('AbsecneTable');
    }

    public function dispenser()
    {
        return $this->hasMany('DispensersTable');
    }

    public function supervisor()
    {
        return $this->belongsTo('SuperVisorInformationTable');
    }

}