<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkerInformationTable extends Eloquent {

	protected $table = 'worker_information_table';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function taskAndAlert()
	{
		return $this->hasMany('TaskAndAlert');
	}

	public function absence()
	{
		return $this->hasMany('AbsecneTable');
	}

	public function dispenser()
	{
		return $this->hasMany('DispensersTable');
	}

	public function supervisor()
	{
		return $this->belongsTo('SuperVisorInformationTable');
	}

}