<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function functions()
    {
        return $this->belongsToMany('Skill');
    }

    public function events()
    {
        return $this->belongsToMany('Event');
    }

}