<?php

namespace Rockit;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Skill extends Model 
{

    protected $table = 'skills';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function membersm()
    {
        return $this->belongsToMany('Member');
    }

    public function events()
    {
        return $this->belongsToMany('Event')->withPivot('nb_people');
    }

    public function staffs()
    {
        return $this->hasMany('Staff');
    }

}