<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanySettingsTable extends Migration {

	public function up()
	{
		Schema::create('company_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('logo', 255)->nullable();
			$table->string('header', 255);
			$table->text('title');
			$table->text('sub_title')->nullable();
			$table->text('caption')->nullable();
			$table->text('footer')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('company_settings');
	}
}