<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentTypesTable extends Migration {

	public function up()
	{
		Schema::create('payment_types', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->float('fee_charge', 8,2);
			$table->boolean('is_active')->default(true);
			$table->boolean('is_primary')->default(false);
			$table->enum('fee_type', array('amount', 'percentage'));
		});
	}

	public function down()
	{
		Schema::drop('payment_types');
	}
}