<?php

namespace App\Models;

class EnrolledCourse extends Eloquent {

	protected $table = 'enrolled_courses';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('course_id', 'student_id', 'certified_at', 'expires_at', 'order_id');

	public function classes()
	{
		return $this->hasMany('App\Models\ClassProgress', 'enrolled_id');
	}

	public function order()
	{
		return $this->belongsTo('App\Models\Order', 'order_id');
	}

}