<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $guarded = array('id');
	protected $fillable = array('student_id', 'student_name', 'address', 'city', 'state', 'country', 'zip');

	public function carts()
	{
		return $this->hasMany('App\Models\Cart', 'order_id');
	}

	public function student()
	{
		return $this->belongsTo('App\Models\Student', 'student_id');
	}

}