<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCalculatorQuestionItemsTable extends Migration {

	public function up()
	{
		Schema::create('calculator_question_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('calculator_question_id')->unsigned();
			$table->decimal('price')->nullable();
			$table->string('image_file_name')->nullable();
			$table->integer('image_file_size')->unsigned()->nullable();
			$table->string('image_content_type')->nullable();
			$table->timestamp('image_updated_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('calculator_question_items');
	}
}